package editor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;

import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class MicroColorCanvas extends JPanel {
	private Image nothingImage;
	private SharedColor sharedColor;
	
	public MicroColorCanvas(SharedColor theSharedColor) {
		
		super();
		
		sharedColor = theSharedColor;
		
		Border border = BorderFactory.createLineBorder(new Color(0,0,0));
		
		this.setBorder(border);
		
		this.setPreferredSize(new Dimension(24, 24));
		this.setMinimumSize(new Dimension(24, 24));
		this.setMaximumSize(new Dimension(24, 24));
		
		ImageIcon tempIcon = new ImageIcon(ColorCanvas.class.getResource("/images/no_bg_color_micro.GIF"));
		
		if(tempIcon != null) {
			nothingImage = tempIcon.getImage();
		} else {
//			System.out.println("Agh!  The image is null!");
		}
		
		refresh();
		
	}
	
	public void paintComponent(Graphics g) {
		
		super.paintComponent(g);
		
		if(sharedColor != null && sharedColor.getColor() != null) {
			
			Color currentPreviewColor = sharedColor.getColor();
			
			Color origColor = g.getColor();
			
			if(currentPreviewColor != null) {
				g.setColor(currentPreviewColor);
				g.fillRect(2, 2, 20, 20);
				g.setColor(origColor);
			} else {
				g.drawImage(nothingImage, 2, 2, 20, 20, null);
			}
			
		} else {
			g.drawImage(nothingImage, 2, 2, 20, 20, null);
		}
		
	}
	
	public void refresh() {
		this.repaint();
	}
	
}
